/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class KeyPair
implements Cloneable {
    protected PublicKey publicKey_;
    protected PrivateKey privateKey_;

    public KeyPair(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey == null) {
            throw new NullPointerException("Argument \"publicKey\" must not be null.");
        }
        if (privateKey == null) {
            throw new NullPointerException("Argument \"privateKey\" must not be null.");
        }
        this.publicKey_ = publicKey;
        this.privateKey_ = privateKey;
    }

    public Object clone() {
        KeyPair keyPair;
        try {
            keyPair = (KeyPair)super.clone();
            keyPair.privateKey_ = (PrivateKey)this.privateKey_.clone();
            keyPair.publicKey_ = (PublicKey)this.publicKey_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return keyPair;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof KeyPair) {
            KeyPair keyPair = (KeyPair)object;
            bl = this == keyPair || this.publicKey_.equals(keyPair.publicKey_) && this.privateKey_.equals(keyPair.privateKey_);
        }
        return bl;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey_;
    }

    public PublicKey getPublicKey() {
        return this.publicKey_;
    }

    public int hashCode() {
        return this.publicKey_.hashCode() ^ this.privateKey_.hashCode();
    }

    public void setPrivateKey(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("Argument \"privateKey\" must not be null.");
        }
        this.privateKey_ = privateKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("Argument \"publicKey\" must not be null.");
        }
        this.publicKey_ = publicKey;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("  ");
        stringBuffer.append(this.publicKey_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append(this.privateKey_);
        return stringBuffer.toString();
    }
}

